import java.io.*;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import java.util.*;

public class Test {

	public static void main(String[] args) throws IOException {
		if(args.length==0) {
			String[] tmp = { "src.png", "dx", "out.png" };
			args = tmp;
		}
		String of = args[args.length-1];
		double[][] mat = Utils.loadMatrix(args[0]);
		for(int i=1; i<args.length-1; i++) {
			if(args[i].startsWith("-dog")) {
				String[] a = args[i].split(",");
				int iter1 = 30, iter2 = 30;
				boolean flag = true;
				switch(a.length) {
					case 4: flag = new Boolean(a[3]);
					case 3: iter2 = Integer.parseInt(a[2]);
					case 2: iter1 = Integer.parseInt(a[1]);
				}
				mat = Utils.dog(mat, null, iter1, iter2, flag);
				if(flag) {
					Utils.saveSignedMatrix(of, mat, 0.9, 20);
				} else {
					Utils.saveSignedMatrix(of, mat, 10, 20);
				}
				return;
			}
			if(args[i].startsWith("-smooth")) {
				int iter=10;
				String[] a = args[i].split(",");
				switch(a.length) {
					case 2: iter = Integer.parseInt(a[1]);
				}
				mat = Utils.smooth(null, iter);
				continue;
			}
			if(args[i].startsWith("-copy")) {
				double[][] out = new double[mat.length+40][mat[0].length+10];
				mat = Utils.copy(mat, out, 5, 20);
				continue;
			}
			if(args[i].startsWith("-grad")) {
				int iter=1;
				double factor=5;
				String[] a = args[i].split(",");
				switch(a.length) {
					case 3: factor = Double.parseDouble(a[2]);
					case 2: iter = Integer.parseInt(a[1]);
				}
				mat = Utils.smooth(mat, iter);
				mat = Utils.grad(mat, null);
				mat = Utils.add(mat, factor, 0);
				continue;
			}
			if(args[i].startsWith("-d2xd2y")) {
				int iter=1;
				double factor=5;
				boolean flag = false;
				String[] a = args[i].split(",");
				switch(a.length) {
					case 4: flag = new Boolean(a[3]);
					case 3: factor = Double.parseDouble(a[2]);
					case 2: iter = Integer.parseInt(a[1]);
				}
				if(iter>0) mat = Utils.smooth(mat, iter);
				mat = Utils.d2xd2y(mat, null);
				if(flag) {
					Utils.saveSignedMatrix(of, mat, factor, 20);
				} else {
					Utils.saveSignedMatrix(of, mat, factor);
				}
				return;
			}
			if(args[i].startsWith("-dx")) {
				int iter=1;
				double factor=5;
				boolean flag = false;
				String[] a = args[i].split(",");
				switch(a.length) {
					case 4: flag = new Boolean(a[3]);
					case 3: factor = Double.parseDouble(a[2]);
					case 2: iter = Integer.parseInt(a[1]);
				}
				if(iter>0) mat = Utils.smooth(mat, iter);
				mat = Utils.dx(mat, null);
				if(flag) {
					Utils.saveSignedMatrix(of, mat, factor, 20);
				} else {
					Utils.saveSignedMatrix(of, mat, factor);
				}
				return;
			}
			if(args[i].startsWith("-dy")) {
				int iter=1;
				double factor=5;
				boolean flag = false;
				String[] a = args[i].split(",");
				switch(a.length) {
					case 4: flag = new Boolean(a[3]);
					case 3: factor = Double.parseDouble(a[2]);
					case 2: iter = Integer.parseInt(a[1]);
				}
				if(iter>0) mat = Utils.smooth(mat, iter);
				mat = Utils.dy(mat, null);
				if(flag) {
					Utils.saveSignedMatrix(of, mat, factor, 20);
				} else {
					Utils.saveSignedMatrix(of, mat, factor);
				}
				return;
			}
			if(args[i].startsWith("-add")) {
				double factor=1, offset=0;
				String[] a = args[i].split(",");
				switch(a.length) {
					case 3: offset = Double.parseDouble(a[2]);
					case 2: factor = Integer.parseInt(a[1]);
				}
				mat = Utils.add(mat, factor, offset);
				continue;
			}
			if(args[i].startsWith("-flip")) {
				mat = Utils.vflip(mat);
				continue;
			}
		}
		Utils.saveMatrix(of, mat);
	}
}

class Utils {

	public static double[] weights = {0.299,  0.587, 0.114};

	public static double rgbToDouble(int rgb, double[] weights) {
		double tmp = (rgb & 255) * weights[2];
		tmp += ((rgb>>8) & 255) * weights[1];
		tmp += ((rgb>>16) & 255) * weights[0];
		return tmp;
	}

	public static double rgbToDouble(int rgb) {
		double tmp = (rgb & 255);
		tmp += ((rgb>>8) & 255);
		tmp += ((rgb>>16) & 255);
		return tmp/3;
	}

	public static double blueToDouble(int rgb) {
		double tmp = (rgb & 255);
		return tmp;
	}

	public static double[][] bufferdImageToMatrix(BufferedImage img, double[] w) {
		double[][] tmp = new double[img.getHeight()][img.getWidth()];
		for(int i=0; i<tmp.length; i++) {
			for(int j=0; j<tmp[0].length; j++) {
				tmp[i][j] = rgbToDouble(img.getRGB(j, i), w);
			}
		}
		return tmp;
	}

	public static double[][] bufferdImageToMatrix(BufferedImage img) {
		double[][] tmp = new double[img.getHeight()][img.getWidth()];
		for(int i=0; i<tmp.length; i++) {
			for(int j=0; j<tmp[0].length; j++) {
				tmp[i][j] = rgbToDouble(img.getRGB(j, i));
			}
		}
		return tmp;
	}

	public static double[][] loadMatrix(String fn, double[] w) throws IOException {
		BufferedImage img = ImageIO.read(new File(fn));
		return bufferdImageToMatrix(img, w);
	}

	public static double[][] loadMatrix(String fn) throws IOException {
		if(fn.startsWith("ASC:")) {
			return loadMatrixAsc(fn.substring(4));
		}
		if(fn.endsWith(".asc")) {
			return loadMatrixAsc(fn);
		}
		if(fn.endsWith(".obj")) {
			return loadJavaMatrix(fn);
		}
		if(fn.endsWith(".pgm")) {
			return loadPgm(fn);
		}
		BufferedImage img = ImageIO.read(new File(fn));
		return bufferdImageToMatrix(img);
	}

	public static void saveMatrix(String fn, double[][] mat) throws IOException {
		if(fn.endsWith(".asc")) {
			saveMatrixAsc(fn, mat);
			return;
		}
		if(fn.endsWith(".obj")) {
			saveJavaMatrix(fn, mat);
			return;
		}
		if(fn.endsWith(".pgm")) {
			savePgm(fn, mat);
			return;
		}
		BufferedImage img = new BufferedImage(mat[0].length, mat.length, BufferedImage.TYPE_3BYTE_BGR);
		for(int i=0; i<mat.length; i++) {
			for(int j=0; j<mat[i].length; j++) {
				int rgb = (int) mat[i][j];
				if(rgb>255) rgb=255;
				else if(rgb<0) rgb=0;
				img.setRGB(j, i, rgb * 0x10101);
			}
		}
		ImageIO.write(img, fn.substring(fn.lastIndexOf('.')+1), new File(fn));
	}

	public static void saveSignedMatrix(String fn, double[][] mat, double fact) throws IOException {
		BufferedImage img = new BufferedImage(mat[0].length, mat.length, BufferedImage.TYPE_3BYTE_BGR);
		for(int i=0; i<mat.length; i++) {
			for(int j=0; j<mat[i].length; j++) {
				int rgb = (int) (mat[i][j]*fact+128);
				if(rgb>255) rgb=255;
				else if(rgb<0) rgb=0;
				img.setRGB(j, i, rgb * 0x10101);
			}
		}
		ImageIO.write(img, fn.substring(fn.lastIndexOf('.')+1), new File(fn));
	}

	public static void saveSignedMatrix(String fn, double[][] mat, double fact, double offset) throws IOException {
		BufferedImage img = new BufferedImage(mat.length, mat[0].length, BufferedImage.TYPE_3BYTE_BGR);
		for(int i=0; i<mat.length; i++) {
			for(int j=0; j<mat[i].length; j++) {
				if(mat[i][j]>0) {
					int val = (int) (mat[i][j]*fact+offset);
					if(val>255) val=255;
					else if(val<1) val=1;
					img.setRGB(j, i, val * 0x100);
				} else if(mat[i][j]<0) {
					int val = (int) (-mat[i][j]*fact+offset);
					if(val>255) val=255;
					else if(val<1) val=1;
					img.setRGB(j, i, val * 0x10001);
				}
			}
		}
		ImageIO.write(img, fn.substring(fn.lastIndexOf('.')+1), new File(fn));
	}

	static public double[][] copy3(double[][] in, double[][] out, int xoffset, int yoffset) {
		final int w = out[0].length, h = out.length, w1 = in[0].length, h1 = in.length;
		for(int i=0; i<h; i++) {
			int ii = (i - yoffset);
			if(ii>=h1) continue;
			else if(ii<0) continue;
			for(int j=0; j<w; j++) {
				int jj = (j - xoffset);
				if(jj>=w1) continue;
				else if(jj<0) continue;
				out[i][j] = in[ii][jj];
			}
		}
		return out;
	}

	static public double[][] copy(double[][] in, double[][] out, int xoffset, int yoffset) {
		final int w = out[0].length, h = out.length, w1 = in[0].length, h1 = in.length;
		for(int i=0; i<h; i++) {
			int ii = (i - yoffset);
			if(ii>=h1) ii = 2*h1-ii-2;
			else if(ii<0) ii=-ii;
			for(int j=0; j<w; j++) {
				int jj = (j - xoffset);
				if(jj>=w1) jj = 2*w1-jj-2;
				else if(jj<0) jj=-jj;
				out[i][j] = in[ii][jj];
			}
		}
		return out;
	}

	static public double[][] copy2(double[][] in, double[][] out, int xoffset, int yoffset) {
		final int w = out[0].length, h = out.length, w1 = in[0].length, h1 = in.length;
		for(int i=0; i<h; i++) {
			int ii = (i - yoffset);
			if(ii>=h1) ii = h1-1;
			else if(ii<0) ii=0;
			for(int j=0; j<w; j++) {
				int jj = (j - xoffset);
				if(jj>=w1) jj = w1-1;
				else if(jj<0) jj=0;
				out[i][j] = in[ii][jj];
			}
		}
		return out;
	}

	static public double[][] copy1(double[][] in, double[][] out, int xoffset, int yoffset) {
		final int w = out[0].length, h = out.length, w1 = in[0].length, h1 = in.length;
		final int w2 = w1*2, h2 = h1*2;
		if(xoffset<0) xoffset += 2*w1;
		if(yoffset<0) yoffset += 2*h1;
		for(int i=0; i<h; i++) {
			int ii = (i + yoffset) % h2 ;
			if(ii>=h1) ii = h2-1-ii;
			for(int j=0; j<w; j++) {
				int jj = (j + xoffset) % w2;
				if(jj>=w1) jj = w2-1-jj;
				out[i][j] = in[ii][jj];
			}
		}
		return out;
	}

	public static void saveMatrixAsc(String fn, double[][] mat) throws IOException {
		PrintStream out = new PrintStream(fn);
		out.printf("#ASC %d %d\n", mat[0].length, mat.length);
		for(int i=0; i<mat.length; i++) {
			for(int j=0; j<mat[i].length; j++) {
				int rgb = (int) (mat[i][j]);
				if(rgb>255) rgb=255;
				else if(rgb<0) rgb=0;
				out.println(rgb);
			}
		}
	}

	public static void savePgm(String fn, double[][] mat) throws IOException {
		PrintStream out = new PrintStream(fn);
		out.printf("P2\n%d %d\n255\n", mat[0].length, mat.length);
		for(int i=0; i<mat.length; i++) {
			for(int j=0; j<mat[i].length; j++) {
				out.println(mat[i][j]);
			}
		}
	}

	public static double[][] loadMatrixAsc(String fn) throws IOException {
		Scanner in = new Scanner(new File(fn));
		in.useLocale(Locale.UK);
		if(!in.next().equals("#ASC")) throw new IOException(fn+": not a ASC file");
		int w = in.nextInt();
		int h = in.nextInt();
		double[][] mat = new double[h][w];
		for(int i=0; i<mat.length; i++) {
			for(int j=0; j<mat[i].length; j++) {
				mat[i][j] = in.nextDouble();
			}
		}
		in.close();
		return mat;
	}

	public static double[][] loadPgm(String fn) throws IOException {
		Scanner in = new Scanner(new File(fn));
		in.useLocale(Locale.UK);
		if(!in.next().equals("P2")) throw new IOException(fn+": not a PGM file");
		int w = in.nextInt();
		int h = in.nextInt();
		int max = in.nextInt();
		double[][] mat = new double[h][w];
		for(int i=0; i<mat.length; i++) {
			for(int j=0; j<mat[i].length; j++) {
				mat[i][j] = in.nextInt();
			}
		}
		in.close();
		return mat;
	}

	public static void saveJavaMatrix(String fn, double[][] obj) throws IOException {
		FileOutputStream fos = new FileOutputStream(fn);
		ObjectOutputStream oos = new ObjectOutputStream(fos);
		oos.writeObject(obj);
		oos.close();
		fos.close();
	}

	public static double[][] loadJavaMatrix(String fn) throws IOException {
		try {
			FileInputStream fis = new FileInputStream(fn);
			ObjectInputStream ois = new ObjectInputStream(fis);
			Object obj = ois.readObject();
			ois.close();
			fis.close();
			return (double[][])obj;
		}
		catch(ClassNotFoundException e) {
			throw new IOException(e);
		}
	}

	public static double[][] xSmooth(double[][] in, double[][] out) {
		if(out==null) out = new double[in.length][in[0].length];
		for(int i=0; i<in.length; i++) {
			for(int j=1; j<in[0].length-1; j++) {
				out[i][j] = (in[i][j-1] + in[i][j+1])*0.25 + in[i][j]*0.5;
			}
		}
		return out;
	}

	public static double[][] ySmooth(double[][] in, double[][] out) {
		if(out==null) out = new double[in.length][in[0].length];
		for(int i=1; i<in.length-1; i++) {
			for(int j=0; j<in[0].length; j++) {
				out[i][j] = (in[i-1][j] + in[i+1][j])*0.25 + in[i][j]*0.5;
			}
		}
		return out;
	}

	public static double[][] smooth(double[][] in, int iter) {
		double[][] tmp = new double[in.length][in[0].length];
		for(int i=0; i<iter; i++) {
			xSmooth(in, tmp);
			ySmooth(tmp, in);
		}
		return in;
	}

	public static double[][] smooth(double[][] in, double[][] out, int iter) {
		if(out==null) out = new double[in.length][in[0].length];
		else if(in==out) throw new IllegalArgumentException("Utils.smooth: in==out");
		double[][] tmp = xSmooth(in, null);
		ySmooth(tmp, out);
		for(int i=1; i<iter; i++) {
			xSmooth(out, tmp);
			ySmooth(tmp, out);
		}
		return out;
	}

	public static double[][] dog(double[][] in, double[][] out, int iter1, int iter2, boolean flag) {
		if(out==null) out = new double[in.length][in[0].length];
		else if(in==out) throw new IllegalArgumentException("Utils.smooth: in==out");
		double[][] tmp = xSmooth(in, null);
		ySmooth(tmp, out);
		for(int i=1; i<iter1; i++) {
			xSmooth(out, tmp);
			ySmooth(tmp, out);
		}
		tmp = xSmooth(out, tmp);
		double[][] out1 = ySmooth(tmp, null);
		for(int i=1; i<iter2; i++) {
			xSmooth(out1, tmp);
			ySmooth(tmp, out1);
		}
		if(flag) {
			for(int i=0; i<in.length; i++) {
				for(int j=0; j<in[0].length; j++) {
					if(out[i][j]>out1[i][j]) out[i][j] = 1+in[i][j];
					else if(out[i][j]<out1[i][j]) out[i][j] = -1-in[i][j];
				}
			}
		} else {
			for(int i=0; i<in.length; i++) {
				for(int j=0; j<in[0].length; j++) {
					out[i][j] -= out1[i][j];
				}
			}
		}
		return out;
	}

	public static double[][] dx(double[][] in, double[][] out) {
		if(out==null) out = new double[in.length][in[0].length];
		for(int i=0; i<in.length; i++) {
			for(int j=1; j<in[0].length-1; j++) {
				out[i][j] = (in[i][j+1] - in[i][j-1])*0.5;
			}
		}
		return out;
	}

	public static double[][] dy(double[][] in, double[][] out) {
		if(out==null) out = new double[in.length][in[0].length];
		for(int i=1; i<in.length-1; i++) {
			for(int j=0; j<in[0].length; j++) {
				out[i][j] = (in[i+1][j] - in[i-1][j])*0.5;
			}
		}
		return out;
	}

	public static double[][] grad(double[][] in, double[][] out) {
		if(out==null) out = new double[in.length][in[0].length];
		double[][] dx = dx(in, null);
		double[][] dy = dy(in, null);
		for(int i=1; i<in.length-1; i++) {
			for(int j=1; j<in[0].length-1; j++) {
				out[i][j] = Math.hypot(dx[i][j], dy[i][j]);
			}
		}
		return out;
	}

	public static double[][] gradThreshold(double[][] in, double[][] out, double th) {
		if(out==null) out = new double[in.length][in[0].length];
		double[][] dx = dx(in, null);
		double[][] dy = dy(in, null);
		for(int i=1; i<in.length-1; i++) {
			for(int j=1; j<in[0].length-1; j++) {
				if(Math.abs(dx[i][j])>th || Math.abs(dy[i][j])>th) out[i][j] = 255;
			}
		}
		return out;
	}

	public static double[][] gradAbs(double[][] in, double[][] out, double th) {
		if(out==null) out = new double[in.length][in[0].length];
		double[][] dx = dx(in, null);
		double[][] dy = dy(in, null);
		for(int i=1; i<in.length-1; i++) {
			for(int j=1; j<in[0].length-1; j++) {
				out[i][j] = Math.abs(dx[i][j]) + Math.abs(dy[i][j]);
			}
		}
		return out;
	}

	public static double[][] gradPhase(double[][] in, double[][] out) {
		if(out==null) out = new double[in.length][in[0].length];
		double[][] dx = dx(in, null);
		double[][] dy = dy(in, null);
		for(int i=1; i<in.length-1; i++) {
			for(int j=1; j<in[0].length-1; j++) {
				out[i][j] = Math.atan2(dy[i][j], dx[i][j]);
			}
		}
		return out;
	}

	public static void grad(double[][] in, double[][] mod, double[][]  phase) {
		for(int i=1; i<in.length-1; i++) {
			for(int j=1; j<in[0].length-1; j++) {
				double dx = (in[i][j+1] - in[i][j-1]);
				double dy = (in[i+1][j] - in[i-1][j]);
				mod[i][j] = Math.hypot(dx, dy)*0.5;
				phase[i][j] = Math.atan2(dy, dx);
			}
		}
	}

	public static double[][] d2xd2y(double[][] in, double[][] out) {
		if(out==null) out = new double[in.length][in[0].length];
		for(int i=1; i<in.length-1; i++) {
			for(int j=1; j<in[0].length-1; j++) {
				out[i][j] = (in[i+1][j] + in[i-1][j] + in[i][j+1] + in[i][j-1])*0.25 - in[i][j];
			}
		}
		return out;
	}

	public static double[][] d2x(double[][] in, double[][] out) {
		if(out==null) out = new double[in.length][in[0].length];
		for(int i=1; i<in.length-1; i++) {
			for(int j=1; j<in[0].length-1; j++) {
				out[i][j] = (in[i][j+1] + in[i][j-1])*0.5 - in[i][j];
			}
		}
		return out;
	}

	public static double[][] d2y(double[][] in, double[][] out) {
		if(out==null) out = new double[in.length][in[0].length];
		for(int i=1; i<in.length-1; i++) {
			for(int j=1; j<in[0].length-1; j++) {
				out[i][j] = (in[i+1][j] + in[i-1][j])*0.5 - in[i][j];
			}
		}
		return out;
	}

	public static double[][] add(double[][] in, double factor, double offset) {
		for(int i=0; i<in.length; i++) {
			for(int j=0; j<in[0].length; j++) {
				in[i][j] = in[i][j]*factor+offset;
			}
		}
		return in;
	}

	public static double[][] addSigned(double[][] in, double factor, double offset) {
		for(int i=0; i<in.length; i++) {
			for(int j=0; j<in[0].length; j++) {
				if(in[i][j]>0) {
					in[i][j] = in[i][j]*factor+offset;
					if(in[i][j]<0) in[i][j]=0;
				} else if(in[i][j]<0) {
					in[i][j] = -in[i][j]*factor-offset;
					if(in[i][j]>0) in[i][j]=0;
				}
			}
		}
		return in;
	}

	public static double[][] vflip(double[][] in) {
		double[][] tmp = new double[in.length][];
		for(int i=0; i<in.length; i++) {
			tmp[i] = in[in.length-1-i];
		}
		return tmp;
	}

	public static double[][] clone(double[][] in) {
		double[][] tmp = new double[in.length][];
		for(int i=0; i<in.length; i++) {
			tmp[i] = in[i].clone();
		}
		return tmp;
	}
}
