abstract public class Morph {

	public abstract double pixelOperation(int i, int j);

	protected final int iter;
	protected double[][] in, out, result=null;

	public double[][] getMatrix() {
		if(result==null) run();
		return result;
	}

	public Morph(double[][] in, double[][] out, int iter) {
		this.iter = iter;
		this.in = in;
		if(out==null) {
			out = new double[in.length][in[0].length];
			for(int j=1; j<in[0].length-1; j++) {
				out[0][j] = in[0][j];
				out[in.length-1][j] = in[in.length-1][j];
			}
			for(int i=0; i<in.length; i++) {
				out[i][0] = in[i][0];
				out[i][in[0].length-1] = in[i][in[0].length-1];
			}
		}
		this.out = out;
	}

	public void run() {
		for(int i=0; i<iter; i++) {
			op();
			double[][] tmp = in;
			in = out;
			out = tmp;
		}
		result = in;
	}

	public void op() {
		for(int i=1; i<in.length-1; i++) {
			for(int j=1; j<in[i].length-1; j++) {
				out[i][j] = pixelOperation(i, j);
			}
		}
	}
}
