import java.io.IOException;

public class Erode extends Morph {

	public Erode(double[][] in, double[][] out, int i) {
		super(in, out, i);
	}

	public double pixelOperation(int i, int j) {
		if(in[i][j]<128) return 0;
		if(in[i-1][j]<128) return 0;
		if(in[i][j-1]<128) return 0;
		if(in[i][j+1]<128) return 0;
		if(in[i+1][j]<128) return 0;
		return 255;
	}

	public static void main(String[] args) throws IOException {
		int iter = args.length>2? Integer.parseInt(args[2]) : 1;
		double[][] in = Utils.loadMatrix(args[0]);
		Morph op = new Erode(in, null, iter);
		Utils.saveMatrix(args[1], op.getMatrix());
	}
}
