import java.io.IOException;

public class Dilate8 extends Morph {

	public Dilate8(double[][] in, double[][] out, int i) {
		super(in, out, i);
	}

	public double pixelOperation(int i, int j) {
		if(in[i][j]>128) return 255;
		if(in[i-1][j]>128) return 255;
		if(in[i][j-1]>128) return 255;
		if(in[i][j+1]>128) return 255;
		if(in[i+1][j]>128) return 255;
		if(in[i-1][j-1]>128) return 255;
		if(in[i-1][j+1]>128) return 255;
		if(in[i+1][j-1]>128) return 255;
		if(in[i+1][j+1]>128) return 255;
		return 0;
	}

	public static void main(String[] args) throws IOException {
		int iter = args.length>2? Integer.parseInt(args[2]) : 1;
		double[][] in = Utils.loadMatrix(args[0]);
		Morph op = new Dilate8(in, null, iter);
		Utils.saveMatrix(args[1], op.getMatrix());
	}
}
