import java.io.IOException;
import java.io.File;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;

public class ColorMorph {

	int pixelOperation(int i, int j) {
		int val = in[i][j];
		int rmax = (val >> 16) & 255;
		int gmax = (val >> 8) & 255;
		int bmax = val & 255;

		val = in[i-1][j];
		int v = (val >> 16) & 255;
		if(v>rmax) rmax = v;
		v = (val >> 8) & 255;
		if(v>gmax) gmax = v;
		v = val & 255;
		if(v>bmax) bmax = v;

		val = in[i][j-1];
		v = (val >> 16) & 255;
		if(v>rmax) rmax = v;
		v = (val >> 8) & 255;
		if(v>gmax) gmax = v;
		v = val & 255;
		if(v>bmax) bmax = v;

		val = in[i][j+1];
		v = (val >> 16) & 255;
		if(v>rmax) rmax = v;
		v = (val >> 8) & 255;
		if(v>gmax) gmax = v;
		v = val & 255;
		if(v>bmax) bmax = v;

		val = in[i+1][j];
		v = (val >> 16) & 255;
		if(v>rmax) rmax = v;
		v = (val >> 8) & 255;
		if(v>gmax) gmax = v;
		v = val & 255;
		if(v>bmax) bmax = v;

		return (rmax<<16) | (gmax<<8) | bmax;
	}

	protected int iter;
	protected int[][] in, out, result=null;

	public int[][] getMatrix() {
		if(result==null) run();
		return result;
	}

	public ColorMorph init(String[] args) {
		iter = args.length>2? Integer.parseInt(args[2]) : 1;
		loadMatrix(args[0]);
		out = new int[in.length][in[0].length];
		for(int j=1; j<in[0].length-1; j++) {
			out[0][j] = in[0][j];
			out[in.length-1][j] = in[in.length-1][j];
		}
		for(int i=0; i<in.length; i++) {
			out[i][0] = in[i][0];
			out[i][in[0].length-1] = in[i][in[0].length-1];
		}
		return this;
	}

	public void run() {
		for(int i=0; i<iter; i++) {
			op();
			int[][] tmp = in;
			in = out;
			out = tmp;
		}
		result = in;
	}

	public void op() {
		for(int i=1; i<in.length-1; i++) {
			for(int j=1; j<in[i].length-1; j++) {
				out[i][j] = pixelOperation(i, j);
			}
		}
	}

	public static void main(String[] args) {
		new ColorMorph().init(args).saveMatrix(args[1]);
	}

	public void loadMatrix(String fn) {
		try {
			BufferedImage img = ImageIO.read(new File(fn));
			in = new int[img.getHeight()][];
			for(int i=0; i<in.length; i++) {
				in[i] = img.getRGB(0, i, img.getWidth(), 1, null, 0, img.getWidth());
			}
		} catch(IOException e) {
			System.err.println(e);
			System.exit(1);
		}
	}


	public void saveMatrix(String fn) {
		try {
			int[][] mat = getMatrix();
			BufferedImage img = new BufferedImage(mat[0].length, mat.length, BufferedImage.TYPE_3BYTE_BGR);
			for(int i=0; i<mat.length; i++) {
				img.setRGB(0, i, img.getWidth(), 1, mat[i], 0, img.getWidth());
			}
			ImageIO.write(img, fn.substring(fn.lastIndexOf('.')+1), new File(fn));
		} catch(IOException e) {
			System.err.println(e);
			System.exit(1);
		}
	}
}
