package cv.imageframe;

import java.awt.image.BufferedImage;
import java.io.File;

import javax.imageio.ImageIO;

public class Transpose {

	public static void main(String[] args) throws Exception {
		String fn = args.length>0 ? args[0] : "lena-c.png";
		BufferedImage img = ImageIO.read(new File(fn));
		int w=img.getWidth(), h=img.getHeight();
		BufferedImage out = new BufferedImage(h, w, img.getType());
		for(int i=0; i<h; i++) {
			for(int j=0; j<w; j++) {
				int  rgb = img.getRGB(j, i);
				out.setRGB(i, j, rgb);
			}
		}
		if(args.length>1) {
			String ext = args[1].substring(args[1].lastIndexOf('.')+1);
			if(!ImageIO.write(out, ext, new File(args[1]))) {
				System.err.println(args[1]+":"+ext);
			}
		} else {
			new ImageFrame(out, "transposed image");
		}
	}

}
