package cv.imageframe;

import java.awt.image.BufferedImage;
import java.io.File;

import javax.imageio.ImageIO;

public class ToGray {

	static double[] ww = { 0, 0, 1, 0 };
	
	public static void main(String[] args) throws Exception {
		String s = System.getProperty("ww");
		if(s!=null) {
			boolean debug = false;
			if(s.startsWith("?")) {
				debug = true;
				s = s.substring(1);
			}
			String[] a = s.split(",");
			switch(a.length) {
			case 1:
				if(a[0].length()==0) {
					ww[0] = ww[1] = ww[2] = 0.3333;
					ww[3] = 1-(ww[0]+ww[1]+ww[2]);
					break;
				}
				ww[0] = Double.parseDouble(a[0]);
				ww[1] = ww[2] = (1-ww[0])/2;
				break;
			case 2:
				ww[0] = Double.parseDouble(a[0]);
				ww[1] = Double.parseDouble(a[1]);
				ww[2] = 1-(ww[0]+ww[1]);
				break;
			case 3:
				ww[0] = Double.parseDouble(a[0]);
				ww[1] = Double.parseDouble(a[1]);
				ww[2] = Double.parseDouble(a[2]);
				ww[3] = 1-(ww[0]+ww[1]+ww[2]);
				break;
			default:
				ww[0] = Double.parseDouble(a[0]);
				ww[1] = Double.parseDouble(a[1]);
				ww[2] = Double.parseDouble(a[2]);
				ww[3] = Double.parseDouble(a[3]);
				break;
			}
			if(debug) {
				System.err.println(ww[0]+" "+ww[1]+" "+ww[2]+" "+ww[3]);
				System.exit(0);
			}
		}
		BufferedImage img = ImageIO.read(new File(args[0]));
		int w = img.getWidth(), h = img.getHeight();
		int min = 255, max = 0, v;
		int[] rgb = img.getRGB(0, 0, w, h, null, 0, w);
		for(int i=0; i<rgb.length; i++) {
			if(ww[0]==8) {
				v = ((rgb[i]>>16) & 255);
				int g = (rgb[i]>>8) & 255;
				if(g>v) v=g;
				g = rgb[i] & 255;
				if(g>v) v=g;
			} else {
				v = (int) (((rgb[i]>>16) & 255) * ww[0] + ((rgb[i]>>8) & 255) * ww[1] + (rgb[i] & 255) * ww[2] + ww[3]);
				if(v<0) v=0;
				else if(v>255) v=255;
			}
			rgb[i] = v * 0x10101;
			if(min>v) min = v;
			else if(max<v) max = v;
		}
		BufferedImage brightness = new BufferedImage(w, h, BufferedImage.TYPE_3BYTE_BGR);
		brightness.setRGB(0, 0, w, h, rgb, 0, w);
		if(args.length>1) {
			String ext = args[1].substring(args[1].lastIndexOf('.')+1);
			if(!ImageIO.write(brightness, ext, new File(args[1]))) {
				System.err.println(args[1]+":"+ext);
			}
		} else {
			new ImageFrame(brightness, "gray").setLocation(100, 300);
		}
		//System.err.println(max + " " + min);
	}

}
