package cv.imageframe;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

public class Threshold {
	
	public static void main(String[] args) throws IOException {
		BufferedImage img = ImageIO.read(new File(args[0]));
		new ImageFrame(img, args[0]);
		for(int i=1; i<args.length; i++) {
			int th = Integer.decode(args[i]);
			BufferedImage out = threshold(img, th);
			new ImageFrame(out, "th="+th);
		}
	}
	
	static private BufferedImage threshold(BufferedImage img, int th) {
		int w = img.getWidth();
		int h = img.getHeight();
		int[] pix = img.getRGB(0, 0, w, h, null, 0, w);
		for(int j=0; j<pix.length; j++) pix[j] = (pix[j]&255) < th ? 0xff000000 : 0xffffffff;
		BufferedImage out = new BufferedImage(w, h, BufferedImage.TYPE_3BYTE_BGR);
		out.setRGB(0, 0, w, h, pix, 0, w);
		return out;
	}

}
