package cv.imageframe;

import java.awt.image.BufferedImage;
import java.io.File;

import javax.imageio.ImageIO;

public class Subimage {
	
	public static void main(String[] args) throws Exception {
		String fn = args.length>0 ? args[0] : "lena-c.png";
		BufferedImage img = ImageIO.read(new File(fn));
		int w=img.getWidth(), h=img.getHeight();
		int x0=(w)/2;
		int y0=(h)/2;
		img = img.getSubimage(x0, y0, w/2, h/2);
		if(args.length>2) {
			String ext = args[2].substring(args[2].lastIndexOf('.')+1);
			if(!ImageIO.write(img, ext, new File(args[2]))) {
				System.err.println(args[2]+":"+ext);
			}
		} else {
			new ImageFrame(img, "new image");
		}
	}

}
