package cv.imageframe;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;

import javax.imageio.ImageIO;

public class ShiftHSB {

	public static void main(String[] args) throws Exception {
		String fn = args.length>0 ? args[0] : "lena-c.png";
		float inc = args.length>1 ? Float.parseFloat(args[1]) : 0.037F;
		int period = args.length>2 ? Integer.parseInt(args[2]) : 3000;
		BufferedImage img = ImageIO.read(new File(fn));
		int w=img.getWidth(), h=img.getHeight();
		int[] rgb = new int[w*h];
		ImageFrame f = new ImageFrame(fn);
		while(true) {
			Thread.sleep(period);
			img.getRGB(0, 0, w, h, rgb, 0, w);
			for(int i=0; i<rgb.length; i++) {
				rgb[i] = shiftHSB(rgb[i], inc);
			}
			img.setRGB(0, 0, w, h, rgb, 0, w);
			f.setImage(img);
		}
	}

	static int shiftHSB(int rgb, float inc) {
		float[] tmp = new float[3];
		int r = (rgb >> 16)&255;
		int g = (rgb >> 8)&255;
		int b = rgb & 255;
		Color.RGBtoHSB(r, g, b, tmp);
		return Color.HSBtoRGB(tmp[0]+inc, tmp[1], tmp[2]);
	}

}
