package cv.imageframe;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

public class RGBtoHSB {

	public static void main(String[] args) throws IOException {
		float[] tmp = new float[3];
		if(args.length==1 && args[0].lastIndexOf('.')<0) {
			int rgb = Integer.parseInt(args.length>0 ? args[0] : "8060f0", 16);
			java.awt.Color.RGBtoHSB((rgb>>16)&255, (rgb>>8)&255, rgb&255, tmp);
			System.out.println((int) (tmp[0]*240) + " " + (int) (tmp[1]*255) + " " + (int) (tmp[2]*255));
			System.exit(0);
		}

		BufferedImage img = ImageIO.read(new File(args[0]));
		int w = img.getWidth(), h = img.getHeight();
		int[] rgb = img.getRGB(0, 0, w, h, null, 0, w);
		for(int i=0; i<rgb.length; i++) {
			java.awt.Color.RGBtoHSB((rgb[i]>>16)&255, (rgb[i]>>8)&255, rgb[i]&255, tmp);
			int r = ((int) (tmp[0]*240))<<16;
			int g = ((int) (tmp[1]*255))<<8;
			int b = ((int) (tmp[2]*255));
			rgb[i] = r | g | b;
		}
		BufferedImage brightness = new BufferedImage(w, h, BufferedImage.TYPE_3BYTE_BGR);
		brightness.setRGB(0, 0, w, h, rgb, 0, w);
		if(args.length>1) {
			String ext = args[1].substring(args[1].lastIndexOf('.')+1);
			if(!ImageIO.write(brightness, ext, new File(args[1]))) {
				System.err.println(args[1]+":"+ext);
			}
		} else {
			new ImageFrame(brightness, "hsb").setLocation(100, 300);
		}
	}

}
