package cv.imageframe;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

public class RGBtoH {

	public static void main(String[] args) throws IOException {
		float[] tmp = new float[3];
		BufferedImage img = ImageIO.read(new File(args[0]));
		int w = img.getWidth(), h = img.getHeight();
		int[] rgb = img.getRGB(0, 0, w, h, null, 0, w);
		for(int i=0; i<rgb.length; i++) {
			java.awt.Color.RGBtoHSB((rgb[i]>>16)&255, (rgb[i]>>8)&255, rgb[i]&255, tmp);
			if(tmp[1]<0.05) tmp[1] = 0; else tmp[1] = 1;
			if(tmp[2]<0.05) tmp[2] = 0; else tmp[2] = 1;
			rgb[i] = java.awt.Color.HSBtoRGB(tmp[0], tmp[1], tmp[2]);
		}
		BufferedImage brightness = new BufferedImage(w, h, BufferedImage.TYPE_3BYTE_BGR);
		brightness.setRGB(0, 0, w, h, rgb, 0, w);
		if(args.length>1) {
			String ext = args[1].substring(args[1].lastIndexOf('.')+1);
			if(!ImageIO.write(brightness, ext, new File(args[1]))) {
				System.err.println(args[1]+":"+ext);
			}
		} else {
			new ImageFrame(img, args[0]).setLocation(50, 50);
			new ImageFrame(brightness, "hue").setLocation(100, 300);
		}
	}

}
