package cv.imageframe;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

public class Negative {
	
	public static void main(String[] imageFileNames) throws IOException {
		for(int i=0; i<imageFileNames.length; i++) {
			BufferedImage img = ImageIO.read(new File(imageFileNames[i]));
			BufferedImage neg = neg(img);
			new ImageFrame(neg, imageFileNames[i]);
		}
	}
	
	static private BufferedImage neg(BufferedImage img) {
		int w = img.getWidth();
		int h = img.getHeight();
		int[] pix = img.getRGB(0, 0, w, h, null, 0, w);
		for(int j=0; j<pix.length; j++) pix[j] ^= 0xffffff;
		BufferedImage out = new BufferedImage(w, h, BufferedImage.TYPE_4BYTE_ABGR);
		out.setRGB(0, 0, w, h, pix, 0, w);
		return out;
	}

}
