package cv.imageframe;

import java.awt.image.BufferedImage;
import java.io.File;

import javax.imageio.ImageIO;

public class Lut {

	public static void main(String[] args) throws Exception {
		String fn = args.length>0 ? args[0] : "lena-c.png";
		BufferedImage img = ImageIO.read(new File(fn));
		int w=img.getWidth(), h=img.getHeight();
		int[] rgb = new int[w*h];
		if(args.length<=1) new ImageFrame(fn);
		int[] lut = readLut();
		img.getRGB(0, 0, w, h, rgb, 0, w);
		for(int i=0; i<rgb.length; i++) {
			rgb[i] = newpixel(rgb[i], lut);
		}
		img.setRGB(0, 0, w, h, rgb, 0, w);
		if(args.length>1) {
			fn = args[1];
			int index = fn.lastIndexOf('.');
			ImageIO.write(img, fn.substring(index+1), new File(fn));
		} else {
			new ImageFrame(img, "lut");
		}
	}

	static int newpixel(int rgb, int[] lut) {
		int r = (rgb >> 16)&255;
		int g = (rgb >> 8)&255;
		int b = rgb & 255;
		return 0xff000000 | (lut[r] << 16) | (lut[g] << 8) | (lut[b]);
	}

	static int[] readLut() {
		java.util.Scanner in = new java.util.Scanner(System.in);
		int[] l = new int[256];
		for(int i=0; i<256; i++) {
			l[i] = in.nextInt();
			if(l[i]<0) l[i] = 0;
			else if(l[i]>255) l[i] = 255;
		}
		return l;
	}

}
