package cv.imageframe;

import java.awt.image.BufferedImage;
import java.io.File;

import javax.imageio.ImageIO;

public class Insert {

	public static void main(String[] args) throws Exception {
		String fn = args.length>0 ? args[0] : "lena-c.png";
		BufferedImage img = ImageIO.read(new File(fn));
		int w=img.getWidth(), h=img.getHeight();
		int[] rgb = img.getRGB(0, 0, w, h, null, 0, w);
		String fn2 = args.length>1 ? args[1] : "tigre-64.png";
		img = ImageIO.read(new File(fn2));
		int w2=img.getWidth(), h2=img.getHeight();
		if(w2>w || h2>h) {
			System.err.println(fn2 + " is not smaller than " + fn + "!");
			System.exit(1);
		}
		int x0=(w-w2)/2;
		int y0=(h-h2)/2;
		img.getRGB(0, 0, w2, h2, rgb, y0*w+x0, w);
		img = new BufferedImage(w, h, BufferedImage.TYPE_3BYTE_BGR);
		img.setRGB(0, 0, w, h, rgb, 0, w);
		if(args.length>2) {
			String ext = args[2].substring(args[2].lastIndexOf('.')+1);
			if(!ImageIO.write(img, ext, new File(args[2]))) {
				System.err.println(args[2]+":"+ext);
			}
		} else {
			new ImageFrame(img, "new image");
		}
	}

}
