package cv.imageframe;

import java.awt.Frame;
import java.awt.TextArea;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

public class HistogramFrame {
	
	public static void main(String[] args) throws IOException {
		BufferedImage img = ImageIO.read(new File(args[0]));
		new ImageFrame(img, args[0]);
		int w = img.getWidth(), h = img.getHeight();
		int[] B = img.getRGB(0, 0, w, h, null, 0, w);
		int[] istogramma = new int[256];
		for(int i=0; i<B.length; i++) {
			int v = B[i] & 255;
			istogramma[v]++;
			B[i] = v * 0x10101;
		}
		BufferedImage brightness = new BufferedImage(w, h, BufferedImage.TYPE_3BYTE_BGR);
		brightness.setRGB(0, 0, w, h, B, 0, w);
		new ImageFrame(brightness, "Brightness").setLocation(100, 300);
		String out = "";
		for(int i=0; i<istogramma.length; i++) out += i + " " + istogramma[i] + "\n";
		Frame f = new Frame("Histogram");
		f.add(new TextArea(out));
		f.setBounds(600, 100, 150, 400);
		f.setVisible(true);
	}

}
