package cv.imageframe;

import java.awt.image.BufferedImage;
import java.io.File;

import javax.imageio.ImageIO;

public class FlipVertical {

	public static void main(String[] args) throws Exception {
		String fn = args.length>0 ? args[0] : "lena-c.png";
		BufferedImage img = ImageIO.read(new File(fn));
		int w=img.getWidth(), h=img.getHeight();
		int[][] rgb = new int[h][];
		for(int i=0; i<h; i++) rgb[i] = img.getRGB(0, i, w, 1, null, 0, w);
		for(int i=0; i<h/2; i++) {
			int[] tmp = rgb[i];
			rgb[i] = rgb[h-1-i];
			rgb[h-1-i] = tmp;
		}
		for(int i=0; i<h; i++) img.setRGB(0, i, w, 1, rgb[i], 0, w);
		if(args.length>1) {
			String ext = args[1].substring(args[1].lastIndexOf('.')+1);
			if(!ImageIO.write(img, ext, new File(args[1]))) {
				System.err.println(args[1]+":"+ext);
			}
		} else {
			new ImageFrame(img, "flipped image");
		}
	}

}
