package cv.imageframe;

import java.awt.image.BufferedImage;
import java.io.File;

import javax.imageio.ImageIO; 

public class FlipHorizontal {

	public static void main(String[] args) throws Exception {
		String fn = args.length>0 ? args[0] : "lena-c.png";
		BufferedImage img = ImageIO.read(new File(fn));
		int w=img.getWidth(), h=img.getHeight();
		for(int i=0; i<h; i++) {
			for(int j=0; j<w/2; j++) {
				int  rgb1 = img.getRGB(j, i);
				int  rgb2 = img.getRGB(w-1-j, i);
				img.setRGB(j, i, rgb2);
				img.setRGB(w-1-j, i, rgb1);
			}
		}
		if(args.length>1) {
			String ext = args[1].substring(args[1].lastIndexOf('.')+1);
			if(!ImageIO.write(img, ext, new File(args[1]))) {
				System.err.println(args[1]+":"+ext);
			}
		} else {
			new ImageFrame(img, "flipped image");
		}
	}

}
