package cv.imageframe;

import java.awt.image.BufferedImage;
import java.io.File;

import javax.imageio.ImageIO;

public class Crop {

	public static void main(String[] args) throws Exception {
		BufferedImage img = ImageIO.read(new File(args[0]));
		int w=img.getWidth(), h=img.getHeight();
		int x0, y0;
		String[] a = args[1].split(",");
		int debug = Integer.getInteger("debug", 0);
		switch(a.length) {
		case 0:
			new ImageFrame(img, args[0]);
			System.err.printf("w=%d h=%d type=%d\n", w, h, img.getType());
			return;
		case 1:
			x0 = y0 = Integer.parseInt(a[0]);
			w -= 2*x0;
			h -= 2*y0;
			break;
		case 2:
			x0 = Integer.parseInt(a[0]);
			y0 = Integer.parseInt(a[1]);
			w -= x0;
			h -= y0;
			break;
		case 3:
			x0 = Integer.parseInt(a[0]);
			y0 = Integer.parseInt(a[1]);
			w = h = Integer.parseInt(a[2]);
			break;
		default:
			x0 = Integer.parseInt(a[0]);
			y0 = Integer.parseInt(a[1]);
			w = Integer.parseInt(a[2]);
			h = Integer.parseInt(a[3]);
			break;
		}
		int[] rgb = img.getRGB(x0, y0, w, h, null, 0, w);
		img = new BufferedImage(w, h, img.getType());
		img.setRGB(0, 0, w, h, rgb, 0, w);
		if(args.length>3) {
			String ext = args[3].substring(args[3].lastIndexOf('.')+1);
			if(!ImageIO.write(img, ext, new File(args[3]))) {
				System.err.println(args[3]+":"+ext);
			}
		} else {
			new ImageFrame(img, "new image");
			if(debug>0) {
				System.err.printf("x0=%d y0=%d w=%d h=%d type=%d\n", x0, y0, w, h, img.getType());
			}
		}
	}

}

