package cv.imageframe;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

public class Bool {
	
	public static void main(String[] imageFileNames) throws IOException {
		long and = -1, xor = 0;
		int index = imageFileNames[0].indexOf(',');
		if(index<0) {
			and = Long.decode(imageFileNames[0]);
		} else if(index==0) {
			xor = Long.decode(imageFileNames[0].substring(1));
		} else {
			and = Long.decode(imageFileNames[0].substring(0, index));
			xor = Long.decode(imageFileNames[0].substring(index+1));
		}
		for(int i=1; i<imageFileNames.length; i++) {
			BufferedImage img = ImageIO.read(new File(imageFileNames[i]));
			BufferedImage neg = bool(img, (int) and, (int) xor);
			new ImageFrame(neg, imageFileNames[i]);
		}
	}
	
	static private BufferedImage bool(BufferedImage img, int and, int xor) {
		int w = img.getWidth();
		int h = img.getHeight();
		int[] pix = img.getRGB(0, 0, w, h, null, 0, w);
		for(int j=0; j<pix.length; j++) pix[j] &= and;
		for(int j=0; j<pix.length; j++) pix[j] ^= xor;
		BufferedImage out = new BufferedImage(w, h, BufferedImage.TYPE_4BYTE_ABGR);
		out.setRGB(0, 0, w, h, pix, 0, w);
		return out;
	}

}
