package cv.imageframe;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

public class AnimatedImageFile extends AnimatedImage {

	protected AnimatedImageFile(int period, String fn, int w, int h) {
		super(period, fn, w, h);
	}
	
	static int[] rgb;
	
	public static void main(String[] args) {
		try {
			String fn = args.length>0 ? args[0] : "lena.png";
			int period = args.length>1 ? Integer.parseInt(args[1]) : 50;
			BufferedImage img = ImageIO.read(new File(fn));
			int w = img.getWidth();
			int h = img.getHeight();
			rgb = img.getRGB(0, 0, w, h, null, 0, w);
			new AnimatedImageFile(period, fn, w, h);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	protected void createByteBuffer() {
		pixels = new byte[w*h];
		for(int i=0; i<pixels.length; i++) {
			pixels[i] = (byte) rgb[i];
		}
	}

}
