package cv.imageframe;

import java.awt.*;
import java.awt.image.*;
import java.util.*;

public class AnimatedImage extends TimerTask {

	protected void createByteBuffer() {
		pixels = new byte[w*h];
		for(int i=0; i<h; i++) {
			for(int j=0; j<w; j++) {
				pixels[i*w+j] = (byte) (Math.hypot(i-h/2, j-w/2)/2);
			}
		}
	}

	protected IndexColorModel createLut() {
		int[] lut = new int[256];
		for(int i=0; i<256; i++) {
			lut[(i+offset) & 255] = Color.HSBtoRGB(i/256.0F, 1, 1);
		}
		offset++;
		return new IndexColorModel(8, 256, lut, 0, false, 256, DataBuffer.TYPE_BYTE);
	}

	protected AnimatedImage(int period, String title, int w, int h) {
		this.w = w;
		this.h = h;
		createByteBuffer();
		mis = new MemoryImageSource(w, h, createLut(), pixels, 0, w);
		mis.setAnimated(true);
		new ImageFrame(Toolkit.getDefaultToolkit().createImage(mis), title).setLocation(100, 100);
		new Timer().schedule(this, 0, period);
	}

	protected MemoryImageSource mis;
	protected byte[] pixels;
	protected final int w, h;
	protected int offset = 0;

	public void run() {
		mis.newPixels(pixels, createLut(), 0, w);
	}

	public static void main(String[] args) {
		int period = args.length>0 ? Integer.parseInt(args[0]) : 50;
		String title = args.length>1 ? args[1] : "Animated Image";
		new AnimatedImage(period, title, 511, 511);
	}
}