package cv.bin;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Locale;

import javax.imageio.ImageIO;

public class Histogram {
	
	public static void main(String[] args) throws Exception {
		String fn = args.length>0 ? args[0] : "lena-c.png";
		BufferedImage img = ImageIO.read(new File(fn));
		int w=img.getWidth(), h=img.getHeight();
		int[] rgb = new int[w*h];
		int[] rh=new int[256], gh=new int[256], bh=new int[256];
		img.getRGB(0, 0, w, h, rgb, 0, w);
		for(int i=0; i<rgb.length; i++) {
			int r = (rgb[i] >> 16)&255;
			int g = (rgb[i] >> 8)&255;
			int b = rgb[i] & 255;
			rh[r]++;
			gh[g]++;
			bh[b]++;
		}
		int rm=0, gm=0, bm=0;
		if(args.length==2 && args[1].equals("-e")) {
			for(int i=0; i<256; i++) {
				rm += rh[i];
				gm += gh[i];
				bm += bh[i];
				System.out.printf("%d %d %d\n", 255*rm/rgb.length, 255*gm/rgb.length, 255*bm/rgb.length);
			}
			return;
		}
		if(args.length==2 && args[1].equals("-E")) {
			for(int i=0; i<256; i++) {
				bm += bh[i];
				System.out.printf("%d\n", 255*bm/rgb.length);
			}
			return;
		}
		if(args.length==2 && args[1].equals("-t")) {
			for(rm=0; bm+bh[rm+1]<rgb.length/2; rm++) {
				bm += bh[rm];
				System.out.printf("0\n");
			}
			System.out.printf("128\n");
			for(rm++; rm<256; rm++) {
				System.out.printf("255\n");
			}
			return;
		}
		if(args.length==2 && args[1].equals("-c")) {
			for(int i=0; i<256; i++) {
				rm += rh[i];
				gm += gh[i];
				bm += bh[i];
				System.out.printf("%d %d %d\n", rm, gm, bm);
			}
			return;
		}
		if(args.length==2 && args[1].equals("-n")) {
			for(rm=0; rh[rm]==0; rm++);
			for(gm=255; rh[gm]==0; gm--);
			for(bm=0; bm<rm; bm++) System.out.print("0\n");
			for(; bm<gm; bm++) {
				System.out.printf("%d\n", 255*(bm-rm)/(gm-rm));
			}
			for(; bm<256; bm++) System.out.print("255\n");
			return;
		}
		for(int i=0; i<256; i++) {
			System.out.printf("%d %d %d\n", rh[i], gh[i], bh[i]);
			rm += i*rh[i];
			gm += i*gh[i];
			bm += i*bh[i];
		}
		double l = rgb.length;
		System.err.printf(Locale.UK, "%6.2f %6.2f %6.2f\n", rm/l, gm/l, bm/l);
	}

}
