package cv.bin;

import java.awt.image.*;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class AnimatedBufferedImage {

	static final String TITLE = "Animated BufferedImage";

	@SuppressWarnings("serial")
	static class AnimatedJLabel extends JLabel {

		private WritableRaster raster;
		private static byte[] r, g, b;

		private AnimatedJLabel(String fn) throws IOException {
			BufferedImage image;
			if(fn == TITLE) {
				r = new byte[256];
				g = new byte[256];
				b = new byte[256];
				for (int i = 0; i < r.length; i++) {
					r[i] = (byte) (255 * Math.random());
					g[i] = (byte) (255 * Math.random());
					b[i] = (byte) (255 * Math.random());
				}
				image = createImage();
			} else {
				image = ImageIO.read(new File(System.getProperty("if")));
				ColorModel cm = image.getColorModel();
				if(! (cm instanceof IndexColorModel) ) {
					System.err.println("The image does not use an IndexColorModel\n");
					System.exit(1);
				}
				IndexColorModel icm = (IndexColorModel) cm;
				r = new byte[icm.getMapSize()];
				g = new byte[r.length];
				b = new byte[r.length];
				icm.getBlues(b);
				icm.getReds(r);
				icm.getGreens(g);
			}
			raster = image.getRaster();
			setIcon(new ImageIcon(image));
			new Animation().start();
		}

		private class Animation extends Thread {

			public void run() {
				int sl = Integer.getInteger("Animation.loop", 10);
				try {
					while(true) {
						sleep(sl);
						setIcon(new ImageIcon(new BufferedImage(createColorModel(), raster, false, null)));
					}
				} catch(Exception e) {}
			}
		}

		private static BufferedImage createImage() {
			int width = Integer.getInteger("width", 511);
			int height = Integer.getInteger("height", width);
			byte[] pixels = new byte[width * height];
			for (int i = 0; i < pixels.length; i++) {
				pixels[i] = (byte) (Math.hypot(i/width-height/2, i%width-width/2));
			}
			DataBuffer dataBuffer = new DataBufferByte(pixels, width*height, 0);
			SampleModel sampleModel = new SinglePixelPackedSampleModel(
					DataBuffer.TYPE_BYTE, width, height, new int[] {(byte)0xff});
			WritableRaster raster = Raster.createWritableRaster(sampleModel, dataBuffer, null);
			return new BufferedImage(createColorModel(), raster, false, null);
		}

		private static ColorModel createColorModel() {
			// rotate right LUT
			byte r0 = r[r.length-1], g0 = g[r.length-1], b0 = b[r.length-1];
			for (int i = r.length-1; i > 0; i--) {
				r[i] = r[i-1];
				g[i] = g[i-1];
				b[i] = b[i-1];
			}
			r[0] = r0;
			g[0] = g0;
			b[0] = b0;
			return new IndexColorModel(8, r.length, r, g, b);
		}

	}

	public static void main(String[] args) throws IOException {
		String title = args.length>0 ? args[0] : TITLE;
		JFrame frame = new JFrame();
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.add(new AnimatedJLabel(title));
		frame.pack();
		frame.setVisible(true);
		frame.setTitle(title);
	}
}
